import Link from 'next/link'

export default function Hero() {
  return (
    <section className="relative bg-gradient-to-br from-gray-900 to-gray-900 text-white">
      <div className="absolute inset-0 bg-black/50 z-0"></div>
      
      <div className="container relative z-10 py-32 md:py-40">
        <div className="max-w-4xl mx-auto text-center">
          <h1 className="text-5xl md:text-7xl font-bold mb-6">
            NINE THREE <span className="text-red-600">MERCH</span>
          </h1>
          <p className="text-xl md:text-2xl mb-4 text-yellow-400">
            Premium Auto Detailing & Exclusive Merchandise
          </p>
          <p className="text-lg md:text-xl mb-8 text-gray-300">
            Elevate your ride with professional detailing services and shop our exclusive merchandise collection
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/services" className="btn-primary">
              Book Detailing Service
            </Link>
            <Link href="/shop" className="btn-secondary">
              Browse Shop
            </Link>
          </div>
          
          <div className="mt-12 grid grid-cols-1 md:grid-cols-3 gap-6">
            <div className="text-center">
              <div className="text-4xl mb-2">🚗</div>
              <h3 className="text-lg font-semibold text-yellow-400">Professional Detailing</h3>
              <p className="text-sm text-gray-300">Expert car care services</p>
            </div>
            <div className="text-center">
              <div className="text-4xl mb-2">✨</div>
              <h3 className="text-lg font-semibold text-yellow-400">Quality Products</h3>
              <p className="text-sm text-gray-300">Premium merchandise & gear</p>
            </div>
            <div className="text-center">
              <div className="text-4xl mb-2">📍</div>
              <h3 className="text-lg font-semibold text-yellow-400">Two Locations</h3>
              <p className="text-sm text-gray-300">San Antonio, TX & Roxie, MS</p>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
